{$A-,B-,D+,F-,G+,I-,K-,L+,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y+}
{$M 8192,8192}
{************************************************}
{                                                }
{   Screen Saver Demo for Windows                }
{   Copyright (c) 1992 by Thomas Hvel           }
{   Requires 'The Lights Go Down'                }
{                                                }
{************************************************}

{
  see SS_CRAWL.PAS for description
}

{ $define COL256}  { untersttzung fr farbpalette mit 256 farben }

{ $define RUN}   { mit RUN: standalone (.EXE), sonst .DLL }
{$ifndef RUN}
library ss_Demo;
{$endif}

{$c preload}

uses
{$ifdef COL256}
  ssCommon,            { definitionen fr farbpalette }
{$endif}
  WinTypes, WinProcs, lm_lgd, strings;

const AppName = 'LGD_DEMO';

var
    lEndTime: LongInt;   { zeitdauer (fr Randomizer) }
    fExit: LongInt;      { ende durch eingabe ? }
{$ifdef COL256}
    pif: PInterFace;     { zeiger auf parameterstruktur (von LGD bergeben) }
    fFirstDC: boolean;
{$endif}


function WindowProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var
  hMen: hMenu;
  fFlag: Bool;
  w: Word;
  ps: TPaintStruct;
  dc: HDC;
  lRet: LongInt;
begin
  WindowProc := 0;
  if (LgdDefProc (lRet, window, Message, wParam, lParam)) then
    begin
      WindowProc := lRet;
      exit;
    end;

  case Message of
    wm_Paint:
      begin
	dc := BeginPaint (window, ps);
{$ifdef COL256}
	if fFirstDC then
	  begin
	    UnrealizeObject(pif^.hPal);                       
	    RealizePalette(dc);                    
	    fFirstDC := FALSE;
	    { es gibt wahrscheinlich elegantere wege, dies zu erledigen ...
	      ... vielleicht mit WM_QUERYNEWPALETTE ...
	      wir arbeiten dran ... }
	  end;
{$endif}
		  { hier: eigene zeichenroutinen einbauen }
	EndPaint (window, ps);
	exit;
      end;

    wm_Create:
      begin
      end;

{    wm_EraseBkgnd:
      begin
	WindowProc := 1;
	exit;
      end;}

   wm_Size:
      begin
{       cxClient := LOWORD (lParam);
	cyClient := HIWORD (lParam);
	exit;}
      end;

    wm_Timer:
      begin
	if GetCurrentTime >= lEndTime then
	  begin
	    fExit := 0;
	    DestroyWindow (window);
	    exit;
	  end;
      end;

    wm_KillFocus:
      begin
	if fExit = -1 then
	  begin    { ende vorbereiten }
	    PostMessage (window, wm_Close, 0, 0);
	  end;
      end;


    wm_KeyDown,          { jeder tastendruck beendet den Saver }
    wm_Close,
    wm_lButtonDown,
    wm_mButtonDown,
    wm_rButtonDown:
      begin
	fExit := 1;   { randomizer mu zwischen timeout und abbruch unterscheiden knnen! }
	DestroyWindow (window);
	exit;
      end;

    wm_Destroy:
      begin
	KillTimer (window, 1000);
	PostQuitMessage(0);
	Exit;
      end;
  end;
  WindowProc := DefWindowProc(Window, Message, WParam, LParam);
end;


Function ScreenSaver (duration: LongInt; Flags:LongInt): LongInt;
{$ifndef RUN}
export;
{$endif}
var
  Window: HWnd;
  Message: TMsg;
  f:boolean;
  cCursor, i: integer;
const
  WindowClass: TWndClass = (
    style: cs_HREDRAW + cs_VREDRAW;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: nil;
    lpszClassName: AppName);
begin
  Randomize;
  fExit := -1;
{$ifdef COL256}
  pif := pointer (flags);
  if pif <> nil then
    if (pif^.lLevel <> 0) or
       (pif^.lMagic <> $12348765) then
      pif := nil;     { struktur nicht erkannt }
  fFirstDC := TRUE;
{$endif}

  if HPrevInst = 0 then
  begin
    WindowClass.hInstance := HInstance;
    WindowClass.hIcon := 0;
    WindowClass.hCursor := LoadCursor(0, idc_Cross);
    WindowClass.hbrBackground := GetStockObject(black_Brush);
    if not RegisterClass(WindowClass) then
	;
  end;
  Window := CreateWindow(
    AppName,
    AppName,
    ws_PopUp or ws_Border,
    0,
    0,
    0,
    0,
    0,
    0,
    HInstance,
    nil);
  UpdateWindow(Window);
  SetWindowPos (Window, 0, -1, -1,
		GetSystemMetrics (sm_cxScreen)+2,
		GetSystemMetrics (sm_cyScreen)+2,
		swp_noZOrder);

  ShowWindow (window, sw_Normal);

  cCursor := 0;
  repeat
    i := ShowCursor (false);
    inc (cCursor);
  until i < 0;

  if duration > 0 then
    lEndTime := GetCurrentTime + duration * 1000
  else
    lEndTime := $7fffffff;
  SetTimer (window, 17, 1000, nil);

  while GetMessage(Message, 0, 0, 0) do
  begin
{    if (TranslateAccelerator (window, hAccel, Message) = 0) then
      begin}
	TranslateMessage(Message);
	DispatchMessage(Message);
{      end;}
  end;

  while cCursor > 0 do
    begin
      ShowCursor (true);
      dec (cCursor);
    end;

  UnregisterClass (AppName, hInstance);
  ScreenSaver := fExit;
end;


Procedure ScreenSaverID (var wMagic:integer;
			 var fFunctions:LongInt;
			     achName:pchar;
			     cchName:integer;
			     achDesc:pchar;
			     cchDesc:integer);
export;
begin
  wMagic := $6874;
  fFunctions := 16+8+1;    { 1: about, 2:options, 3:both }
		      { 4: non-blank (nicht-leerer bildschirm erforderlich }
		      { 8: hinterlt leeren bildschirm }
  StrLCopy (achName, 'zBlackness', cchName - 1);
  { das erste zeichen des namens wird nicht angezeigt, es legt
    lediglich die sortierung fest. }
{$ifdef ENGLISH}
  StrLCopy (achDesc, 'Blackness:'#10#10'Simply blanks the screen!'#10#10''#10,
	    cchDesc - 1);
{$else}
  StrLCopy (achDesc, 'Blackness:'#10#10'Macht den Bildschirm schwarz'#10#10'Beispiel eines einfachen Screen Savers'#10,
	    cchDesc - 1);
{$endif}
end;

Procedure ScreenSaverOptions (window: hWND);
export;
begin
end;


Procedure ScreenSaverAbout (window: hWND);
export;
begin
{$ifdef ENGLISH}
  {$ifdef SHARE}
  LgdAboutBox (window, 0,
                       'Blackness',
                       '1992-95 Thomas Hvel Software'#10+
                       'Saturnstr. 45, 53842 Troisdorf, Germany'#10+
                       'All Rights reserved!',
                       FALSE, 3);
  {$else}
  LgdAboutBox (window, 0,
                       'Blackness',
                       '1992-95 Thomas Hvel Software'#10+
                       'Saturnstr. 45, 53842 Troisdorf, Germany'#10+
                       'All Rights reserved!',
                       TRUE, 3);
  {$endif}
{$else}
  {$ifdef SHARE}
  LgdAboutBox (window, 0,
                       'Blackness',
                       '1992-95 Thomas Hvel Software'#10+
                       'Saturnstrae 45, 53842 Troisdorf, Deutschland'#10+
                       'Alle Rechte vorbehalten!',
                       FALSE, 3);
  {$else}
  LgdAboutBox (window, 0,
                       'Blackness',
                       '1992-95 Thomas Hvel Software'#10+
                       'Saturnstrae 45, 53842 Troisdorf, Deutschland'#10+
                       'Alle Rechte vorbehalten!',
                       TRUE, 3);
  {$endif}
{$endif}
end;

{$ifndef RUN}
exports
  ScreenSaverID      index 17,
  ScreenSaverOptions index 18,
  ScreenSaver        index 19,
  ScreenSaverAbout   index 20;
{$endif}

begin
{$ifdef RUN}
  ScreenSaver (20, 0);  { demo fr ca. 20 sekunden }
{$endif}
end.
